{smcl}
{* *! version 1.0.2  14apr2025}{...}
{vieweralsosee "whatsnew" "help whatsnew"}{...}
{title:What's new in release 19 (compared with release 18)}

{pstd}
This file lists the changes corresponding to the creation of Stata 19.0 
and StataNow 19.5 (08apr2025).  See 
{help whatsnewtoc:What's new table of contents} for changes in other 
Stata versions.

{pstd}
We list the changes, item by item, but first, we start with the
highlights.

{pstd}
As always, Stata 19 is 100% compatible with the previous releases,
but we remind programmers that it is important to put {cmd:version 18.5}, 
{cmd:version 18}, {cmd:version 17}, {cmd:version 16.1}, etc., at the top of 
old do- and ado-files so that they continue to work as you expect.  You were 
supposed to do that when you wrote them, but if you did not, go back and do 
it now.

{* ------------------------------------------------------------}{...}
      {bf:Contents}
{p 9 12 2}{help whatsnew18to19##highlights:1{space 2}Highlights}{p_end}
{p 9 12 2}{help whatsnew18to19##NewGeneral:2{space 2}What's new in statistics (general)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewML:3{space 2}What's new in statistics (machine learning)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewBayes:4{space 2}What's new in statistics (Bayesian)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewTE:5{space 2}What's new in statistics (causal inference)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewXT:6{space 2}What's new in statistics (panel data)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewST:7{space 2}What's new in statistics (survival analysis)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewTS:8{space 2}What's new in statistics (time series)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewMeta:9{space 2}What's new in statistics (meta-analysis)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewSEM:10{space 1}What's new in statistics (structural equation models)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewFMM:11{space 1}What's new in statistics (finite mixture models)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewSVY:12{space 1}What's new in statistics (survey data)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewPSS:13{space 1}What's new in statistics (power and sample size)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewSP:14{space 1}What's new in statistics (spatial data)}{p_end}
{p 9 12 2}{help whatsnew18to19##NewDM:15{space 1}What's new in data management}{p_end}
{p 9 12 2}{help whatsnew18to19##NewG:16{space 1}What's new in graphics}{p_end}
{p 9 12 2}{help whatsnew18to19##NewRPT:17{space 1}What's new in reporting}{p_end}
{p 9 12 2}{help whatsnew18to19##NewP:18{space 1}What's new in programming}{p_end}
{p 9 12 2}{help whatsnew18to19##NewMata:19{space 1}What's new in Mata}{p_end}
{p 9 12 2}{help whatsnew18to19##NewGUI:20{space 1}What's new in the interface}{p_end}
{p 9 12 2}{help whatsnew18to19##NewMore:21{space 1}What's more}{p_end}


{* ----------------------------------------------------------}{...}
{marker highlights}{...}
{title:1 Highlights}

{pstd}
The following are the highlights of the Stata 19 release:

{p 5 8 2}
     1. {help whatsnew18to19##h2oml:Machine learning via H2O: Ensemble decision trees}

{p 5 8 2}
     2. {help whatsnew18to19##cate:Conditional average treatment effects (CATEs)}

{p 5 8 2}
     3. {help whatsnew18to19##hdfe:High-dimensional fixed effects (HDFE)}

{p 5 8 2}
     4. {help whatsnew18to19##bayessel:Bayesian variable selection}

{p 5 8 2}
     5. {help whatsnew18to19##stmgint:Interval-censored multiple-event Cox model}

{p 5 8 2}
     6. {help whatsnew18to19##metacorr:Meta-analysis for correlations}

{p 5 8 2}
     7. {help whatsnew18to19##cre:Correlated random-effects (CRE) model}

{p 5 8 2}
     8. {help whatsnew18to19##xtvar:Panel-data vector autoregressive (VAR) model}

{p 5 8 2}
     9. {help whatsnew18to19##bayesboot:Bayesian bootstrap and replicate weights}

{p 4 8 2}
    10. {help whatsnew18to19##cfunc:Control-function linear and probit models}

{p 4 8 2}
    11. {help whatsnew18to19##bqreg:Bayesian quantile regression}

{p 4 8 2}
    12. {help whatsnew18to19##weakinst:Inference robust to weak instruments after IV regression}

{p 4 8 2}
    13. {help whatsnew18to19##ivsvar:SVAR via instrumental variables}

{p 4 8 2}
    14. {help whatsnew18to19##ivlpirf:Instrumental-variables local projections for IRFs}

{p 4 8 2}
    15. {help whatsnew18to19##mundlak:Mundlak specification test}

{p 4 8 2}
    16. {help whatsnew18to19##lcstats:Latent class model-comparison statistics}

{p 4 8 2}
    17. {help whatsnew18to19##doedit:Do-file Editor enhancements}

{p 4 8 2}
    18. {help whatsnew18to19##graphics:New features in graphics}

{p 4 8 2}
    19. {help whatsnew18to19##tables:More powerful tables} 

{p 4 8 2}
    20. {help whatsnew18to19##french:Stata in French}

{pstd}
And that's not all.  The following could have been highlights, too.

        o Modify saved sets of frames
        o Asymmetric Laplace likelihood for Bayesian models 
        o Alternative at-risk table for survival graphs
        o PyStata enhancements
        o Robust standard errors for VAR models
        o Half-Cauchy and Rayleigh priors for Bayesian analysis
        o Bayesian predictions in user-defined evaluators

{pstd}
There is even more.  The highlights are followed by detailed sections
describing all changes.



{* ------------------------------------------------------------}{...}
{marker h2oml}{...}
{title:Highlight 1. Machine learning via H2O: Ensemble decision trees}

{pstd}     
Machine learning methods are often used to solve research and business
problems focused on prediction when the problems require more advanced
modeling than linear or generalized linear models.  Ensemble decision
tree methods, which combine multiple trees for better predictions, are
popular for such tasks.  H2O is a scalable machine learning platform that
supports data analysis and machine learning, including ensemble decision
tree methods such as random forest and gradient boosting machine.

{pstd}
The {helpb h2oml} suite of Stata commands is a wrapper for H2O that
provides end-to-end support for H2O machine learning analysis using
ensemble decision tree methods.  The estimation commands provided are as
follows:

{center:The {cmd:h2oml} estimation commands}
{p2colset 9 34 36 2}{...}
{p2line}
{p2col:Command}Method{p_end}
{p2line}
{p2col:{helpb h2oml gbregress}}gradient boosting regression{p_end}
{p2col:{helpb h2oml gbbinclass}}gradient boosting binary classification{p_end}
{p2col:{helpb h2oml gbmulticlass}}gradient boosting multiclass
classification{p_end}

{p2col:{helpb h2oml rfregress}}random forest regression{p_end}
{p2col:{helpb h2oml rfbinclass}}random forest binary classification{p_end}
{p2col:{helpb h2oml rfmulticlass}}random forest multiclass
classification{p_end}
{p2line}

{pstd}
For example, you can perform gradient boosting binary classification 
of response {cmd:y} using predictors {cmd:x1} and {cmd:x2} with
200 trees, a learning rate of 0.2, and other hyperparameters set to their
default values by typing

{phang2}{cmd:. h2oml gbbinclass y x1 x2, ntrees(200) lrate(0.2)}

{pstd}
The {cmd:h2oml} estimation commands support tuning by allowing you to
specify hyperparameter ranges and control the tuning process with 
option {opt tune()}.  You can adjust the tuning metric (for example, use
accuracy instead of log loss), change the grid-search method (for
example, use a random search instead of Cartesian), and specify other
tuning controls.  Additionally, you can use cross-validation or a
validation frame to evaluate the best model.

{pstd}
The following postestimation commands provide tuning and estimation
summaries:

{center:The {cmd:h2oml} tuning and estimation summary commands}
{p2line}
{p2col:Command}Description{p_end}
{p2line}
{p2col:{helpb h2omlestat metrics}}display performance metrics{p_end}
{p2col:{helpb h2omlgraph scorehistory}}produce score history plot{p_end}
{p2col:{helpb h2omlestat cvsummary}}display cross-validation summary{p_end}
{p2col:{helpb h2omlestat gridsummary}}display grid-search summary{p_end}
{p2col:{helpb h2omlexplore}}explore models after grid search{p_end}
{p2col:{helpb h2omlselect}}select model after grid search{p_end}
{p2col:{helpb h2omlgof}}compare goodness of fit for machine learning
models{p_end}
{p2line}

{pstd}
To evaluate model performance after binary classification and multiclass
classification, you can use the following postestimation commands:

{center:The {cmd:h2oml} performance evaluation commands}
{p2line}
{p2col:Command}Description{p_end}
{p2line}
{p2col:{helpb h2omlestat threshmetric}}display threshold-based metrics{p_end}
{p2col:{helpb h2omlgraph prcurve}}produce precision–recall curve plot{p_end}
{p2col:{helpb h2omlgraph roc}}produce ROC curve plot{p_end}
{p2col:{helpb h2omlestat aucmulticlass}}display AUC and AUCPR metrics{p_end}
{p2col:{helpb h2omlestat hitratio}}display hit-ratio table{p_end}
{p2col:{helpb h2omlestat confmatrix}}display confusion matrix{p_end}
{p2line}

{pstd}
Once the best model is chosen, you can use {helpb h2omlpredict} to
compute predictions.

{pstd}
Finally, you can explain those predictions using the following
postestimation commands:

{center:The {cmd:h2oml} explainability commands}
{p2line}
{p2col:Command}Description{p_end}
{p2line}
{p2col:{helpb h2omlgraph shapvalues}}produce SHAP values plot for individual
observations{p_end}
{p2col:{helpb h2omlgraph shapsummary}}produce SHAP beeswarm plot{p_end}
{p2col:{helpb h2omlgraph varimp}}produce variable importance plot{p_end}
{p2col:{helpb h2omlgraph pdp}}produce partial dependence plot{p_end}
{p2col:{helpb h2omlgraph ice}}produce individual conditional expectation
plot{p_end}
{p2col:{helpb h2omltree}}save decision tree DOT file and display rule
set{p_end}
{p2line}

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/h2oml-trees/":stata.com/stata19/h2oml-trees}.


{marker cate}{...}
{title:Highlight 2. Conditional average treatment effects (CATEs)}

{pstd}
Treatment effects estimate the causal effect of a treatment on an outcome.  This
effect may be constant or it may vary across different subpopulations.  With
new command {helpb cate}, you can go beyond estimating overall treatment effects
to estimating individualized or group-specific ones.  {cmd:cate} helps us answer 
questions such as the following:

        1. Are the treatment effects heterogeneous?
        2. How do the treatment effects vary with some variables?
        3. Do the treatment effects vary across prespecified groups?
{p 8 11 2}
        4. Are there unknown groups in the data for which treatment effects
        differ?{p_end}
        5. Which is best among possible treatment-assignment rules?

{pstd}
{cmd:cate} estimates conditional average treatment effects (CATEs), which are
average treatment effects (ATEs) conditional on a set of variables for which
the treatment effects may vary.  {cmd:cate} provides the estimates of the
treatment effects at different levels:

{p 8 11 2}
      1. Individualized average treatment effects (IATEs): treatment effects
         conditional on the observational-level characteristics.

{p 8 11 2}
      2. Group average treatment effects (GATEs): treatment effects conditional 
         on prespecified groups.

{p 8 11 2}
      3. Sorted group average treatment effects (GATESs): treatment effects for 
         a prespecified number of groups, where the groups are determined by 
         the quantiles of the IATE.

{pstd}
The {cmd:cate} suite provides features to estimate, predict, visualize, and make
inferences about the CATEs.  In particular, its Stata commands can be grouped
into the following categories:

{pstd}
Estimation of IATEs, GATEs, and GATESs:    

{p 8 11 2}
      1. {cmd:cate po} estimates the IATE function by using the
         partialing-out (PO) estimator via the generalized random forest.  This 
         method is also known as causal forest.  For example, to estimate the 
         IATE function for outcome {cmd:y} and treatment {cmd:treat}, 
         conditioning on covariates {cmd:x1} through {cmd:x5} and 
         {cmd:i.group1}, using the PO estimator, we type

{phang3}
{cmd:. cate po (y x1-x5 i.group1) (treat)}

{p 8 11 2}
      2. {cmd:cate aipw} estimates the IATE function by using the augmented 
         inverse probability-weighting (AIPW) estimator via the honest 
         regression random forest.  For example, to estimate the IATE 
         function using the AIPW estimator, we type

{phang3}          
{cmd:. cate aipw (y x1-x5 i.group1) (treat)}

{p 8 11 2}
      3. {cmd:cate} with option {opt controls()} allows us to specify
         high-dimensional control variables in the outcome and treatment 
         models.  For example, to add variables {cmd:w1} through {cmd:w100} 
         as controls in the outcome and treatment models, we type

{phang3}
{cmd:. cate aipw (y x1-x5 i.group1) (treat), controls(w1-w100)}

{p 8 11 2}
      4. {cmd:cate} with option {opt group(varname)} estimates the GATEs.  For 
         example, to estimate GATEs for groups defined by variable 
         {cmd:group2}, we type
            
{phang3}
{cmd:. cate aipw (y x1-x5 i.group1) (treat), group(group2)}

{p 8 11 2}
      5. {cmd:cate} with option {opt group(#)} estimates the GATESs for 
	 {it:#} groups based on the rankings of the IATE estimates.  For example, 
         to divide the data into five groups based on quintiles of the IATE 
         estimates and estimate the GATESs, we type

{phang3}
{cmd:. cate aipw (y x1-x5 i.group1) (treat), group(5)}

{pstd}
Evaluation treatment-assignment policy:

{p 8 11 2}
      1. {cmd:estat ate} computes the ATE for a subpopulation.
        
{p 8 11 2}
      2. {cmd:estat policyeval} computes the average outcome for a 
         treatment-assignment policy or compares the difference of two 
         policies’ average outcomes if specified.

{pstd}
Treatment-effects visualization:    

{p 8 11 2}
      1. {cmd:categraph histogram} plots the histogram of estimated IATEs
         for preliminary inspection of the treatment-effect heterogeneity.

{p 8 11 2}
      2. {cmd:categraph gateplot} plots the GATE or GATES estimate for each
         group and the corresponding confidence intervals.

{p 8 11 2}
      3. {cmd:categraph iateplot} plots the IATE function with varying values 
         of covariates.

{pstd}    
Inference for treatment-effects heterogeneity:

{p 8 11 2}
      1. {cmd:predict} predicts the IATEs, standard errors, and 
         the lower and upper bounds of the pointwise confidence intervals.

{p 8 11 2}
      2. {cmd:estat heterogeneity} tests whether the treatment effects are
         heterogeneous.

{p 8 11 2}
      3. {cmd:estat gatetest} tests whether the estimated GATEs or GATESs 
         are equal across the groups.

{p 8 11 2}
      4. {cmd:estat classification} compares the means of a variable in the 
         group with the largest treatment effect and the group with the 
         smallest treatment effect.  It is used to compare the properties of 
         the subpopulations with the largest and smallest effects.

{p 8 11 2}
      5. {cmd:estat projection} provides a linear approximation of the IATE 
         function by fitting a linear regression of the estimated IATE on a 
         set of variables.

{p 8 11 2}
      6. {cmd:estat series} provides a nonparametric approximation of the
         IATE function by fitting a series regression of the estimated IATE on 
         a set of variables using B-spline, piecewise polynomial spline, or 
         polynomial basis.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/cate/":stata.com/stata19/cate}.


{marker hdfe}{...}
{title:Highlight 3. High-dimensional fixed effects (HDFE)}

{pstd}
You can now absorb not just one but multiple high-dimensional categorical 
variables in your linear regression, with or without fixed effects, and in
linear models accounting for endogeneity using two-stage least squares.  This
provides remarkable speed gains over the traditional approach that includes
indicators for all categories of these variables in your models.

{pstd}
Commands {helpb areg}, {helpb xtreg:xtreg, fe}, and 
{helpb ivregress:ivregress 2sls} now allow option {opt absorb()} to be 
specified with multiple categorical variables.  Previously, {cmd: areg} 
allowed only one variable in option {opt absorb()}, whereas {cmd: xtreg, fe} 
and {cmd: ivregress 2sls} did not allow the option.

{pstd}
Results are adjusted to control for the variables specified in
{cmd:absorb(}{it:varlist}{cmd:)}, but the coefficients on {it:varlist}
are not estimated, and therefore, computation time is
substantially reduced.  The time savings are extraordinary
when high-dimensional categorical variables are absorbed.

{pstd}
For example, say we have repeated cross-sectional
data for 10,000 individuals, for 20 years, across
3,000 counties, and who work in 1,000 industries.  We would like
to see how their work satisfaction is affected by commuting time.
Previously, we would fit the model including year, county, and
industry indicators as follows:

{phang2}
{cmd:. areg satisfaction commute i.(year county industry), absorb(id)}

{pstd}
We care about the coefficient on {cmd:commute}.  All other
variables are controls.  Yet, fitting the model above
implies estimating about 4,000 coefficients while adjusting
for {cmd:id}.  This could take minutes.  Instead, we can type

{phang2}
{cmd:. areg satisfaction commute, absorb(id year county industry)}

{pstd}
The command above takes seconds, and we estimate only
the parameter that matters to our research question.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/hdfe/":stata.com/stata19/hdfe}.


{marker bayessel}{...}
{title:Highlight 4. Bayesian variable selection}

{pstd}
New command {helpb bayesselect} provides Bayesian variable selection for
the linear model.  Bayesian variable selection is appropriate for sparse
regression problems when a few predictors out of many potential predictors 
explain the outcome.  {cmd:bayesselect} accounts for model uncertainty 
during estimation and performs Bayesian inference for the regression
coefficients.  It performs variable selection by using specialized priors 
for regression coefficients to downweight the effects of unimportant 
predictors.  The supported priors include the horseshoe prior,
which belongs to the class of global-local shrinkage priors, and Bayesian
lasso, a member of the spike-and-slab class of priors.

{pstd}
All existing Bayesian postestimation routines are supported after
{cmd:bayesselect}, including {helpb bayespredict} for
performing in- and out-of-sample predictions and diagnostics.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/bayesselect-regress/":stata.com/stata19/bayesselect-regress}.


{marker stmgint}{...}
{title:Highlight 5. Interval-censored multiple-event Cox model}

{pstd}
Interval-censored multiple-event data commonly arise in longitudinal 
studies because each study subject may experience several types of events 
and those events are not observed directly but are known only to occur 
within some time interval.  With new estimation command {helpb stmgintcox}, 
you can fit a marginal Cox proportional hazards model to such data and
account for possible dependence between event times for multiple events.
This command can fit models to either single- or multiple-record-per-event 
data, and it supports time-varying covariates for all events or specific 
ones.  {cmd:stmgintcox} also offers flexible ways to specify models with 
event-specific covariates.

{pstd}
After estimation with {cmd:stmgintcox}, you can create plots of
covariate-adjusted survivor and other functions with {helpb stcurve} 
and produce goodness-of-fit plots with {helpb estat gofplot}.  You can 
also generate event-specific predictions; with  
{helpb stmgintcox_postestimation##predict:predict}'s new option 
{cmd:event()}, you can select the event for which you want predictions.
You can use new postestimation command {helpb estat common} to 
estimate and test average effects of covariates across all events.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/stmgintcox/":stata.com/stata19/stmgintcox}.

 
{marker metacorr}{...}
{title:Highlight 6. Meta-analysis for correlations}
       
{pstd}
Correlation studies are a cornerstone in many fields of research,
often used to determine the strength and direction of the
relationship between two continuous variables.

{pstd}
The {helpb meta} suite has been extended to perform meta-analysis of
correlations.  For instance, you may have studies reporting the
correlation between education and income levels or between physical
activity and improvements in mental health.  In this setting, effect
sizes such as Fisher's {it:z}-transformed correlations are typically
used in the meta-analysis.

{pstd}
Consider a study that reports the correlation coefficient between
physical activity and improvements in mental health indicators (for
example, depression or anxiety) as well as the study sample size.
Suppose that similar studies have been conducted across the country, and the
results are recorded in variables {cmd:rho} and {cmd:ssize}.  To
compute the Fisher's {it:z}-transformed correlations, we type

{phang2}
{cmd:. meta esize rho ssize, fisherz}

{pstd}
Or perhaps we wish to use the raw (untransformed) correlations:

{phang2}
{cmd:. meta esize rho ssize, correlation}

{pstd}
All the commands in the {cmd:meta} suite that are available for
two-sample binary or continuous data are also available for
correlation data.  For example, we may conduct subgroup analysis
using variable {cmd:subgrvar} and request that results be reported
as correlations as opposed to Fisher's {it:z}-values by typing

{phang2}
{cmd:. meta forestplot, subgroup(subgrvar) correlation}

{pstd}
or construct a funnel plot by typing

{phang2}
{cmd:. meta funnelplot}

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/meta-corr/":stata.com/stata19/meta-corr}.


{marker cre}{...}
{title:Highlight 7. Correlated random-effects (CRE) model}

{pstd}
You can now easily fit correlated random-effects (CRE) models to panel
data with the new option {opt cre} of command {helpb xtreg}.  CRE models
help to deal with the endogeneity bias that may arise because of the 
correlation between individual heterogeneity and regressors.  In fact, the
coefficients for variables that change over time in a CRE model are
numerically equivalent to those obtained from a fixed-effects (FE) model.

{pstd}
Unlike FE models, however, CRE models can estimate coefficients for
time-invariant regressors, such as race.  They also provide, at no
additional cost, a fully robust Mundlak specification test to help choose
between estimation using random effects and estimation using FE or CRE.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/cre/":stata.com/stata19/cre}.


{marker xtvar}{...}
{title:Highlight 8. Panel-data vector autoregressive (VAR) model}

{pstd}
New estimation command {helpb xtvar} fits VAR models to panel data.  Each
dependent variable in the system is modeled as a function of its own lags,
the lags of all the other dependent variables, and a panel-level fixed
effect.  Other explanatory variables can be added to the model as well.
These variables can be predetermined, fully exogenous, or endogenous.

{pstd}
After {cmd:xtvar}, you can compute impulse-response functions, perform
Granger causality tests, evaluate the appropriate number of lags
and instruments to include in the model, and use other diagnostics to
which you are accustomed when fitting VAR models to time-series
data.  See {helpb xtvar postestimation:[XT] xtvar postestimation}.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/panel-var/":stata.com/stata19/panel-var}.


{marker bayesboot}{...}
{title:Highlight 9. Bayesian bootstrap and replicate weights}

{pstd}
With new prefix {helpb bayesboot}, you can perform Bayesian bootstrap 
estimation.  Add this prefix to Stata commands and specify the statistics or 
expressions for which you wish to perform Bayesian bootstrap estimation.
{cmd:bayesboot} will generate importance weights using Dirichlet distribution,
apply these weights when performing bootstrap replications, and report the
Bayesian bootstrap estimation results.

{pstd}
You can also use new command {helpb rwgen} and new options for  
prefix {helpb bootstrap} to implement specialized bootstrap schemes.

{p 8 8 2}
{cmd:rwgen} generates standard replication and Bayesian bootstrap weights.
The command provides two methods: {cmd:rwgen bsample} generates 
frequency weights by resampling observations, and {cmd:rwgen bayes} 
generates Bayesian bootstrap weights using Dirichlet distribution.
These weights can be used directly with the {helpb bootstrap} prefix.

{p 8 8 2}
{cmd:bootstrap} has new options {opt fweights()} and {opt iweights()}
for performing bootstrap replications using the custom weights.
{opt fweights()} allows users to specify frequency weight variables for 
resampling, and {opt iweights()} lets users provide importance weight 
variables.  These options extend {cmd:bootstrap}'s  flexibility by allowing 
user-supplied weights instead of internal resampling, making it easier to 
implement specialized bootstrap schemes and enhance reproducibility.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/bayesboot/":stata.com/stata19/bayesboot}.


{marker cfunc}{...}
{title:Highlight 10. Control-function linear and probit models}

{pstd}
You can now fit control-function linear and probit regression models
with new commands {helpb cfregress} and {helpb cfprobit}.
Control-function regression provides a flexible alternative to
traditional instrumental-variable methods for models with endogenous
variables.  You can include continuous, binary, fractional, and count
endogenous variables.  You can flexibly incorporate interactions of endogenous
variables.  And you can easily test for endogeneity.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/control-functions/":stata.com/stata19/control-functions}.


{marker bqreg}{...}
{title:Highlight 11. Bayesian quantile regression}  

{pstd}
Prefix {helpb bayes:bayes} now supports command {helpb qreg} for
fitting Bayesian quantile regression.  Bayesian quantile regression
assumes an asymmetric Laplace distribution for the likelihood
function and combines it with priors for model parameters to
form a posterior model for comprehensive Bayesian inference.

{pstd}
{cmd: bayes: qreg} seamlessly integrates with Bayesian
postestimation commands so that you can easily perform
hypothesis testing and predictive analyses.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/bayes-qreg/":stata.com/stata19/bayes-qreg}.


{marker weakinst}{...}
{title:Highlight 12. Inference robust to weak instruments after IV regression}

{pstd}
New postestimation command {helpb ivregress_postestimation:estat weakrobust}
performs tests on the coefficients of the endogenous regressors
after fitting a model with {helpb ivregress}.  These tests are
valid even when instruments are weak.  {cmd:estat weakrobust} can
also estimate confidence intervals robust to weak instruments
when there is a single endogenous regressor.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/weak-instruments/":stata.com/stata19/weak-instruments}.


{marker ivsvar}{...}
{title:Highlight 13. SVAR via instrumental variables}  

{pstd}
New estimation command {helpb ivsvar} fits structural vector 
autoregressive (SVAR) models via instrumental 
variables.  Instrumental-variables SVAR models, also called proxy SVAR models, 
are an alternative to short-run SVAR models fit by {helpb svar}.  Because 
shocks of interest, the target shocks, are modeled using instrumental 
variables, these models require fewer constraints to identify the structural 
impulse-response functions (IRFs) than are required by the models fit by 
{cmd:svar}.

{pstd}
{cmd:ivsvar} provides two estimators: a generalized method of
moments (GMM) estimator and a minimum distance estimator.  The GMM
estimator allows any number of instruments to proxy for one target
shock.  The minimum distance estimator allows for {it:r} instruments to
proxy for {it:r} target shocks.

{pstd}
You can type

{phang2}
{cmd:. ivsvar gmm y1 y2 (y3 = z1)}

{pstd}
to instrument the {cmd:y3} shock with proxy {cmd:z1}.

{pstd}
When you have multiple instruments and multiple shocks, use
{cmd: ivsvar mdist}.

{pstd}
To graph structural IRFs after {cmd: ivsvar gmm} or
{cmd: ivsvar mdist}, you can type

{phang2}
{cmd:. irf set myirfs.irf}

{phang2}
{cmd:. irf create model}

{phang2}
{cmd:. irf graph sirf}

{pstd}
Specifying {cmd:sirf} plots the structural IRFs, just like
after {cmd:svar}.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/ivsvar/":stata.com/stata19/ivsvar}.


{marker ivlpirf}{...}
{title:Highlight 14. Instrumental-variables local projections for IRFs}

{pstd}
New estimation command {helpb ivlpirf} fits local-projection models
to estimate IRFs and uses instrumental variables to account for
endogeneity in an impulse variable of interest.  Local projections are
used to estimate the effect of shocks on outcome variables.  When
the shock of interest is on an impulse variable that may be endogenous,
{cmd:ivlpirf} can be used to estimate the IRFs, and the impulse
variable may be instrumented using one or more exogenous instruments.

{pstd}
{cmd:ivlpirf} computes either simple or cumulative IRFs.  Type

{phang2}
{cmd:. ivlpirf y1 y2, endogenous(x = z)}

{pstd}
or

{phang2}
{cmd:. ivlpirf y1 y2, endogenous(x = z) cumulative}

{pstd}
After {cmd:ivlpirf}, you can perform tests of hypotheses involving
single or joint impulse responses.  You can also use the {helpb irf}
suite of commands to produce tables and graphs of the estimated IRFs.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/ivlpirf/":stata.com/stata19/ivlpirf}.


{marker mundlak}{...}
{title:Highlight 15. Mundlak specification test}

{pstd}
New postestimation command
{helpb xtreg_postestimation##syntax_estat:estat mundlak} implements a
fully robust Mundlak specification test to aid in the decision between
random-effects estimation and fixed-effects estimation (or,
equivalently, correlated random-effects estimation).  The Mundlak test, 
unlike other specification tests such as the Hausman test, can be 
implemented after robust, cluster-robust, bootstrap, and jackknife 
standard errors have been estimated.  {cmd:estat mundlak} can be used 
after {cmd:xtreg} with options {opt re}, {opt cre}, and {opt fe}.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/mundlak/":stata.com/stata19/mundlak}.


{marker lcstats}{...}
{title:Highlight 16. Latent class model-comparison statistics}

{pstd}
New postestimation command {helpb lcstats} reports latent class 
model-comparison statistics for latent class estimation results 
produced by {helpb fmm} and {helpb gsem}.  Reported statistics include 
fitted log likelihood, sample size, rank, information criteria (AIC,
BIC, corrected AIC, and consistent AIC), entropy, the Vuong-Lo-Mendell-Rubin 
likelihood-ratio test, and the Lo-Mendell-Rubin-adjusted likelihood-ratio 
test.  These statistics are often used to determine the most appropriate 
number of latent classes.

{pstd}
{cmd:lcstats} produces its output using the {helpb collect} system, so you 
can easily customize your table and export it to MS Word, MS Excel, HTML, 
PDF, LaTeX, Markdown, or plain text.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/lcstats/":stata.com/stata19/lcstats}.


{marker doedit}{...}
{title:Highlight 17. Do-file Editor enhancements}

{pstd}
The Do-file Editor has the following additions:

{pstd}
{bf:Autocompletion of variable names, macros, and stored results}.
If you pause briefly as you type, suggestions of variable names
from data in memory, macros, and stored results will appear in
addition to the command names and existing words that appeared
previously.

{pstd}
{bf:Do-file Editor templates}.  You can now save
time and ensure consistency when you create new documents in the
Do-file Editor by using Stata templates and user-defined
templates.

{pstd}
{bf:Do-file Editor current word and selection highlighting}.
The Do-file Editor will now highlight all case-insensitive
occurrences of the current word under the cursor and all
case-sensitive occurrences of the current selection.

{pstd}
{bf:Bracket highlighting}.
The Do-file Editor will now highlight the brackets enclosing
the current cursor position as you move through the document.

{pstd}
{bf:Code folding enhancements}.  You can now quickly fold all
foldable blocks of code in your do-file by using the {bf:Fold all}
menu item.  You can then selectively unfold your code one fold
point at a time to show the more important parts of your do-file,
or you can use the Do-file Editor’s {bf:Unfold all} menu item to
unfold every fold point.  You can also select lines of code and
transform them into a foldable block of code by using the
{bf:Fold selection} menu item.  This can tidy up your code and
increase the code’s readability.
In addition, the code folding feature is now less visually
distracting by using arrow markers in the code folding ribbon to indicate
whether a code fold is expanded or collapsed and to hide expanded code fold
markers unless the user hovers the mouse over the code folding ribbon.

{pstd}
{bf:Do-file Editor temporary and permanent bookmarks}.
The Do-file Editor now supports temporary bookmarks in addition
to permanent bookmarks.  The existing permanent bookmarks are
saved as part of the do-file.  You can use the new temporary
bookmarks to immediately navigate your do-file but without
making any changes to its content.

{pstd}
{bf:Show whitespace and tabs}.  The Do-file Editor can now show
whitespace characters only within a selection instead of always
showing them or not showing them at all.

{pstd}
{bf:Navigator panel}.
The Navigation control from previous releases of Stata has been replaced by
the Navigator panel.  It displays a list of permanent bookmarks and programs
that are in a do-file.  You can quickly jump to the position of a program or
bookmark by double-clicking on the item in the Navigator panel.  You can also
delete and indent bookmarks from the Navigator panel.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/do-file-editor/":stata.com/stata19/do-file-editor}.


{marker graphics}{...}
{title:Highlight 18. New features in graphics}

{pstd}
Many new graphical features are now available:

{pstd}
{bf:Heat maps}.  The new command 
{helpb twoway_heatmap:twoway heatmap} creates a
heat map, which displays values of a numeric variable, {it:z}, across
values of {it:y} and {it:x} as a grid of colored rectangles.

{pstd}
{bf:Range and point plot with capped spikes}.  The new command 
{helpb twoway_rpcap:twoway rpcap} plots points and ranges
indicated by spikes with caps.  These plots are useful for
displaying a value of interest, such as a mean, and the
corresponding confidence interval.

{pstd}
{bf:Range and point plot with spikes}.  The new command 
{helpb twoway_rpspike:twoway rpspike} plots points and ranges
indicated by spikes.  These plots are useful for displaying
a value of interest, such as a mean, and the corresponding
confidence interval.

{pstd}
{bf:Bar graphs with CIs, improved labeling, and control of bar groupings}.
{cmd:graph bar} now supports statistic {opt meanci},
which allows you to graph the mean and corresponding confidence
interval.  You can also use new options {opt catlabellist()}, 
{opt catlabeladdmax}, and {opt catlabelformat()} to control the 
ticks and labels on the categorical axis.  Also, new option 
{opt groupyvars} allows you to group bars for the same 
{it:y} variable together.  Finally, new suboptions {opt prefix()} 
and {opt suffix()} for option {opt blabel()} allow you to add 
a prefix or suffix to the bar labels.

{pstd}
{bf:Dot charts with CIs, improved labeling, and control of dot groupings}.
{cmd:graph dot} now supports statistic {opt meanci},
which allows you to graph the mean and corresponding confidence
interval.  You can also use new options {opt catlabellist()},
{opt catlabeladdmax}, and {opt catlabelformat()} to control the
ticks and labels on the categorical axis.  Also, new option
{opt groupyvars} allows you to group dots for the same
{it:y} variable together.

{pstd}
{bf:Box plots with improved labeling and control of box groupings}.
You can now use options {opt catlabellist()},
{opt catlabeladdmax}, and {opt catlabelformat()} to control the
ticks and labels on the categorical axis.  You can also use new 
option {opt groupyvars} to group boxes for the same
{it:y} variable together.

{pstd}
{bf:Colors by variable for more graphs.}  Option 
{helpb colorvar_options:colorvar()} is now available with 
more twoway plots: {helpb twoway line:line},
{helpb twoway connected:connected}, {helpb twoway tsline:tsline},
{helpb twoway rline:rline}, {helpb twoway rconnected:rconnected},
and {helpb twoway tsrline:tsrline}.  This option allows plots to
vary color of lines, markers, and more based on the values of a
specified variable.

{pstd}
Learn more at 
{browse "https://www.stata.com/stata19/graphics/":stata.com/stata19/graphics}.


{marker tables}{...}
{title:Highlight 19. More powerful tables}

{pstd} 
Stata's features for customizable tables and collections 
now include the following:

{pstd}
{bf:Titles, notes, and exporting for tables}.  Command {helpb table} 
for creating tabulations, tables of summary statistics, tables 
of regression results, and more now allows you to add a title
with new option {cmd:title()}, to add a note with new option {cmd:note()}, 
to control the appearance of the title and notes with new options 
{cmd:titlestyles()} and {cmd:notestyles()}, and to export your table to
your preferred document type with new option {cmd:export()}.
        
{pstd}
{bf:Easier ANOVA tables}.  You can now more easily create and customize 
ANOVA tables after {helpb anova} and {helpb oneway} by collecting the 
new stored matrix {bf:r(ANOVA)}.

{pstd}
{bf:Better labels with collect get}.  With command {helpb collect get}'s 
new option {opt commands()}, you can specify the command names that posted 
the results being consumed.  This allows {cmd:collect get} to search for
 command-specific result labels.

{pstd}
{bf:Determine layout of a collection}.  New command 
{helpb collect query layout} allows you to query a collection's 
layout specification.

{pstd}
{bf:Control factor variables in headers}.  With command
{helpb collect style header}'s new option {opt fvlevels()}, you have more 
control over how factor variables appear in a table.  Specify whether to 
hide or show factor-variable levels in row and column headers.

{pstd}
{bf:Remove results from a collection}.  New command {helpb collect unget} 
allows you to remove selected results from a collection.

{pstd}
{bf:Table-specific notes}.  Command {helpb collect notes} has new option 
{opt fortags()} that allows you to control which table to show the 
specified note.

{pstd}
{bf:Tabulations with measures of association and tests}.  You can now 
easily create customized tables with the results of commands {helpb tabulate} 
and {helpb svy_tabulate:svy: tabulate}.  With new option {cmd:collect()}, 
tabulated statistics are stored in a collection with its own layout and 
styles, which can be further customized and exported to a variety of file 
types.  This is particularly useful when you wish to include measures of 
association from {cmd:tabulate} and tests from {cmd:svy: tabulate}.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/tables/":stata.com/stata19/tables}.


{marker french}{...}
{title:Highlight 20. Stata in French}

{pstd}
Stata's menus, dialogs, and the like can now be displayed in
French.  Manuals and help files remain in English.

{pstd}
If your computer language is set to French ({cmd:fr}), Stata will
automatically
use its French setting.  To change languages manually using Windows or Unix,
select {bf:Edit > Preferences > User-interface language...}.  If you are using
MacOS, select {bf:Stata 19 > Preferences > User-interface language...}.  You
can also change the language from the command line; see
{helpb set locale_ui:[P] set locale_ui}.

{pstd}
StataCorp gratefully acknowledges the efforts of Timberlake, Stata's official
distributor in France, for the translation to French.

{pstd}
Learn more at
{browse "https://www.stata.com/stata19/french/":stata.com/stata19/french}.



{hline}

{marker NewGeneral}{...}
{title:2 What's new in statistics (general)}

{p 5 8 2}
    1. {help whatsnew18to19##hdfe:Highlight of the release: High-dimensional fixed effects (HDFE)}

{p 8 8 2}
       Existing command {helpb areg} now allows option {opt absorb()} to be
       specified with multiple categorical variables.  Results are adjusted 
       to control for variables specified in {cmd:absorb(}{it:varlist}{cmd:)},
       but coefficients are not estimated, which substantially reduces
       computation time.

{p 8 8 2}
       Existing command {helpb ivregress:ivregress 2sls} now allows option 
       {opt absorb()} for absorbing categorical variables.  Results are adjusted
       to control for variables specified in {cmd:absorb(}{it:varlist}{cmd:)},
       but coefficients are not estimated, which substantially reduces
       computation time.

{p 5 8 2}
    2. {help whatsnew18to19##bayesboot:Highlight of the release: Bayesian bootstrap and replicate weights}

{p 8 8 2}
       New prefix {helpb bayesboot} performs Bayesian bootstrap
       estimation of statistics produced by Stata commands.  This
       command streamlines Bayesian bootstrap analysis by combining
       generation of weights and estimation of statistics into a single 
       step.  It automatically generates importance weights using Dirichlet
       distribution and applies them with {helpb bootstrap}'s option
       {opt iweights()}, eliminating the need to manually call {cmd:rwgen} 
       and {cmd:bootstrap} separately.

{p 8 8 2}
       New command {helpb rwgen} generates standard replication and Bayesian 
       bootstrap weights.  The command provides two methods: {cmd:rwgen bsample} 
       generates frequency weights by resampling observations, and 
       {cmd:rwgen bayes} generates Bayesian bootstrap weights using Dirichlet 
       distribution.

{p 8 8 2}
       Existing prefix {helpb bootstrap} has new options 
       {opt fweights()} and {opt iweights()} for performing bootstrap 
       replications using custom weights.  {opt fweights()} allows users to 
       specify frequency weight variables for resampling, and {opt iweights()} 
       lets users provide importance weight variables.

{p 5 8 2}
    3. {help whatsnew18to19##cfunc:Highlight of the release: Control-function linear and probit models}

{p 8 8 2}
       New command {helpb cfregress} fits a control-function linear regression
       model.

{p 8 8 2}
       New command {helpb cfprobit} fits a control-function probit regression
       model.

{p 5 8 2}
    4. {help whatsnew18to19##weakinst:Highlight of the release: Inference robust to weak instruments after IV regression}

{p 8 8 2}
       New postestimation command 
       {helpb ivregress_postestimation:estat weakrobust} performs tests on the
       coefficients of the endogenous regressors after fitting a model with 
       {helpb ivregress}.  These tests are valid even when instruments are 
       weak.

{p 5 8 2}
    5. {help whatsnew18to19##tables:Highlight of the release: More powerful tables}

{p 8 8 2}
       Existing commands {helpb anova} and {helpb oneway} now store their ANOVA 
       table values in matrix {bf:r(ANOVA)}, making it easier to collect
       results and create customized ANOVA tables.

{p 8 8 2}
       Existing command {helpb tabulate} has new option {cmd:collect()}.
       This specifies that the tabulated statistics be stored in a named 
       collection with its own layout and styles, which can be further 
       customized and exported to a variety of file types.

{p 5 8 2}
    6. Existing command {helpb pkequiv} has the following improvements:

{p 8 11 2}
       a. New default option {cmd:log} performs log-scale analysis of
          bioequivalence, following guidance from the US FDA and the
          European EMA.  Old behavior is available under version control.

{p 8 11 2}
       b. Schuirmann's two one-sided tests are now performed by
          default; these tests can be suppressed with new option
          {cmd:notost}.

{p 8 11 2}
       c. New option {cmd:reps()} controls the number of bootstrap
          replications.

{p 8 11 2}
       d. {cmd:pkequiv} returns additional stored results, including
          {bf:r(limit_table)}, a matrix of equivalence limits,
          confidence intervals, and estimates.

{p 5 8 2}
    6. Existing command {helpb nl} now uses Mata's 
       {helpb mf_moptimize:moptimize()} Gauss-Newton algorithm, Mata's 
       {helpb mf_deriv:deriv()} function for computing numerical derivatives, 
       and a substitutable expression parser that allows you to define
       more complicated expressions for linear and nonlinear functions of 
       parameters.  The previous algorithms and substitutable expression 
       parser are preserved under version control.

{p 5 8 2}
    7. Existing command {helpb gmm} with option {cmd:xtinstruments()} and 
       numerical derivatives is now faster, particularly when the number of 
       panels is large.

{p 5 8 2}
    8. Existing command {helpb areg} has new option {opt dfabsorb}.  This 
       option adjusts degrees of freedom for pairwise collinearity between 
       variables specified in option {opt absorb()}.

{p 5 8 2}
    9. Existing command {helpb ivregress:ivregress 2sls} computes regression
       coefficients and their standard errors using the Mata orthogonal
       triangularization routine {helpb mf_qrd:hqrdp}, which is more 
       numerically stable than the routine used prior to Stata 19.  The 
       previous routine is preserved under version control.


{marker NewML}{...}
{title:3 What's new in statistics (machine learning)}

{p 5 8 2}
    1. {help whatsnew18to19##h2oml:Highlight of the release: Machine learning via H2O: Ensemble decision trees}

{p 8 8 2}
       The new {helpb h2oml} suite is a wrapper for H2O that provides 
       end-to-end support for H2O machine learning analysis using ensemble 
       decision tree methods.

{p 8 8 2}
       New estimation commands include the following:

{p 11 14 2}
         a. {helpb h2oml gbregress} performs gradient boosting regression.

{p 11 14 2}
         b. {helpb h2oml gbbinclass} performs gradient boosting binary 
            classification.

{p 11 14 2}
         c. {helpb h2oml gbmulticlass} performs gradient boosting multiclass
            classification.

{p 11 14 2}
         d. {helpb h2oml rfregress} performs random forest regression.

{p 11 14 2}
         e. {helpb h2oml rfbinclass} performs random forest binary 
            classification.

{p 11 14 2}
         f. {helpb h2oml rfmulticlass} performs random forest multiclass
            classification.

{p 8 8 2}
       New postestimation commands include the following:

{p 11 14 2}
         a. {helpb h2omlestat metrics} displays performance metrics.

{p 11 14 2}
         b. {helpb h2omlgraph scorehistory} produces a score history plot.

{p 11 14 2}
         c. {helpb h2omlestat cvsummary} displays the cross-validation summary.

{p 11 14 2}
         d. {helpb h2omlestat gridsummary} displays the grid-search summary.

{p 11 14 2}
         e. {helpb h2omlexplore} explores models after a grid search.

{p 11 14 2}
         f. {helpb h2omlselect} selects a model after a grid search.

{p 11 14 2}
         g. {helpb h2omlgof} compares goodness of fit for machine learning
            models.

{p 11 14 2}
         h. {helpb h2omlestat threshmetric} displays threshold-based metrics.

{p 11 14 2}
         i. {helpb h2omlgraph prcurve} produces the precision–recall curve 
            plot.

{p 11 14 2}
         j. {helpb h2omlgraph roc} produces the receiver operating
            characteristic (ROC) curve plot.

{p 11 14 2}
         k. {helpb h2omlestat aucmulticlass} displays the area under the curve
            (AUC) and the area under the precision-recall curve (AUCPR) 
            metrics.

{p 11 14 2}
         l. {helpb h2omlestat hitratio} displays the hit-ratio table.

{p 11 14 2}
         m. {helpb h2omlestat confmatrix} displays the confusion matrix.

{p 11 14 2}
         n. {helpb h2omlgraph shapvalues} produces the Shapley additive
            explanation (SHAP) values plot for individual observations.

{p 11 14 2}
         o. {helpb h2omlgraph shapsummary} produces the SHAP beeswarm plot.

{p 11 14 2}
         p. {helpb h2omlgraph varimp} produces the variable importance plot.

{p 11 14 2}
         q. {helpb h2omlgraph pdp} produces the partial dependence plot.

{p 11 14 2}
         r. {helpb h2omlgraph ice} produces the individual conditional 
            expectation plot.

{p 11 14 2}
         s. {helpb h2omltree} saves the decision tree DOT file and displays 
            the rule set.


{marker NewBayes}{...}
{title:4 What's new in statistics (Bayesian)}

{p 5 8 2}
    1. {help whatsnew18to19##bayessel:Highlight of the release: Bayesian variable selection}

{p 8 8 2}
       New command {helpb bayesselect} provides Bayesian variable selection for
       the linear model, which is appropriate for sparse regression problems 
       when only a few predictors out of many potential predictors explain
       the outcome.  {cmd:bayesselect} accounts for model uncertainty during 
       estimation and performs Bayesian inference for the regression 
       coefficients.

{p 8 8 2}
       Existing Bayesian postestimation routines are supported after
       {cmd:bayesselect}, including {helpb bayespredict} for
       performing in- and out-of-sample predictions and diagnostics.

{p 5 8 2}
    2. {help whatsnew18to19##bayesboot:Highlight of the release: Bayesian bootstrap and replicate weights}

{p 8 8 2}
       The following commands provide tools for Bayesian bootstrap:

{p 8 11 2}
         a. New prefix {helpb bayesboot} performs Bayesian bootstrap
            estimation of statistics produced by Stata commands.  This
            command streamlines Bayesian bootstrap analysis by combining
            the generation of weights and estimation of statistics into 
            a single step.  It automatically generates importance weights 
            using Dirichlet distribution and applies them with 
            {helpb bootstrap}'s option {opt iweights()}, eliminating
            the need to manually call {cmd:rwgen} and {cmd:bootstrap} 
            separately.

{p 8 11 2}
         b. New command {helpb rwgen} generates standard replication and 
	    Bayesian bootstrap weights.  The command provides two methods:
	    {helpb rwgen:rwgen bsample} generates frequency weights by
	    resampling observations, and {helpb rwgen:rwgen bayes} generates
	    Bayesian bootstrap weights using Dirichlet distribution.  These
	    weights can be used directly with prefix {helpb bootstrap}, making
	    it easier to perform bootstrap analyses with custom resampling
	    schemes.

{p 8 11 2}
         c. Existing prefix {helpb bootstrap} has new options 
            {opt fweights()} and {opt iweights()} for performing bootstrap 
            replications using custom weights.  {opt fweights()} allows users 
            to specify frequency weight variables for resampling, and 
            {opt iweights()} lets users provide importance weight variables.
            These options extend {helpb bootstrap}'s flexibility by allowing
            user-supplied weights instead of internal resampling, making it 
            easier to implement specialized bootstrap schemes and enhance 
            reproducibility.

{p 5 8 2}
    3. {help whatsnew18to19##bqreg:Highlight of the release: Bayesian quantile regression}

{p 8 8 2}
       Existing prefix {helpb bayes:bayes:} now supports command 
       {helpb qreg} for fitting Bayesian quantile 
       regression.  {cmd: bayes: qreg} seamlessly integrates with Bayesian
       postestimation commands so that you can easily perform hypothesis 
       testing and predictive analyses.

{p 5 8 2}
    4. Existing estimation command {helpb bayesmh} supports a new likelihood, 
       {cmd:asymlaplaceq()}, in option {cmd:likelihood()}.
       {cmd:asymlaplaceq(}{it:sigma}{cmd:, }{it:tau}{cmd:)} specifies an
       asymmetric Laplace (quantile) distribution with scale {it:sigma} and 
       quantile {it:tau}.

{p 8 8 2}
       The new likelihood is useful for fitting asymmetric Laplace Bayesian
       models, also known as Bayesian quantile regressions, including 
       random-effects, multilevel, and multivariate quantile regressions.

{p 8 8 2}
       Learn more at
       {browse "https://www.stata.com/stata19/bayes-asym-laplace/":stata.com/stata19/bayes-asym-laplace}.

{p 5 8 2}
    5. Existing estimation command {helpb bayesmh} now provides Gibbs sampling
       for normal linear models with Laplace priors.  {cmd: bayesmh} with 
       univariate normal likelihood and Laplace prior for regression 
       coefficients or with mean parameter of normal prior and Laplace
       hyperprior now supports Gibbs sampling via suboption {opt gibbs}
       of option {opt block()}.

{p 5 8 2}
    6. Existing estimation command {helpb bayesmh} and prefix
       {helpb bayes} have the following new priors:

{p 8 11 2}
         a. {cmd:bayesmh} and {cmd:bayes:} now support a half-Cauchy prior.
            {cmd:halfcauchy(}{it:loc}{cmd:, }{it:beta}{cmd:)} specifies a
            half-Cauchy distribution with location {it:loc} and scale 
            {it:beta}.  This heavy-tailed prior is useful for modeling 
            nonnegative parameters such as variances and standard deviations 
            that tend to have large values.
 
{p 8 11 2}
         b. {cmd:bayesmh} and {cmd:bayes:} now support a Rayleigh prior.
            {cmd:rayleigh(}{it:beta}{cmd:)} specifies a Rayleigh distribution
            with scale {it:beta}.  This prior distribution is related to
            chi-squared and exponential distributions and thus can be used to
            model nonnegative parameters with skewed distributions.  It is
            often used in physics and engineering to model parameters -- for
            instance, wind speed -- that correspond to a norm of a bivariate
            standard normal random vector.

{p 5 8 2}
    7. Existing command {helpb bayesmh} with user-defined evaluators has the
       following new features:

{p 8 11 2}
         a. {helpb bayesmh} now supports suboption {cmd:reffects} in option
            {cmd:block()} for efficient estimation of random-effects parameters 
            in evaluators.  This option is implied whenever random effects are 
            included in the model.  The old, less efficient estimation of
            random-effects parameters is preserved under version control for 
            reproducibility.

{p 11 11 2}
            Also, options {cmd:evaluator()} and {cmd:llevaluator()} support
            suboption {cmd:reparameters()} that allows the values of
            random-effects parameters to be passed to the evaluator as 
            temporary variables.  These temporary variables are listed as 
            arguments to the evaluators after the names of temporary scalars 
            and matrices for model parameters specified in suboption 
            {opt parameters()}.

{p 8 11 2}
         b. {helpb bayesmh} now supports predictions in evaluators.  Users may
            implement predictions in their posterior or likelihood evaluators 
            and be able to use postestimation command {helpb bayespredict} 
            after {helpb bayesmh}.

{p 11 11 2}
            Specifically, options {cmd:evaluator()} and {cmd:llevaluator()}
            support suboption {cmd:predict} that indicates that the evaluator
            includes code for generating random samples for the outcome.  If
            suboption {opt predict} is not specified with the evaluator in
            {helpb bayesmh}, an attempt to generate Bayesian predictions with
            {helpb bayespredict} for the corresponding outcome will result in 
            an error.

{p 8 11 2}
         c. Evaluators in {helpb bayesmh} are now expected to compute
            log-likelihood values over the observation sample and return them 
            in a vector form instead of returning the scalar overall 
            log-likelihood value.  The old behavior is preserved under version 
            control.  The evaluators can also return the scalar overall 
            log-likelihood value when new suboption {cmd:scalarlnden} is 
            specified in option {cmd:evaluator()} or {cmd:llevaluator()}.


{marker NewTE}{...}
{title:5 What's new in statistics (causal inference)}

{p 5 8 2}
    1. {help whatsnew18to19##cate:Highlight of the release: Conditional average treatment effects (CATEs)}

{p 8 8 2}
       New estimation command {helpb cate} estimates three types of 
       CATEs: individualized average treatment effects (IATEs), group
       average treatment effects (GATEs), and sorted group average
       treatment effects (GATESs).

{p 8 8 2}
       The following postestimation commands are available after {cmd:cate}:

{p 8 11 2}
      a. {cmd:estat ate} computes the ATE for a subpopulation.

{p 8 11 2}
      b. {cmd:estat policyeval} evaluates and compares the prespecified
         treatment-assignment policy.

{p 8 11 2}
      c. {cmd:categraph histogram} plots the histogram of estimated IATEs and
         shows how the IATEs are distributed.

{p 8 11 2}
      d. {cmd:categraph gateplot} plots the estimate of the GATE or GATES and
         its confidence interval for each group.

{p 8 11 2}
      e. {cmd:categraph iateplot} plots the IATE function with varying values
         of covariates.

{p 8 11 2}
      f. {cmd:predict} predicts the IATE function, its standard errors, and
         the lower and upper bounds of the pointwise confidence intervals.

{p 8 11 2}
      g. {cmd:estat heterogeneity} tests whether the treatment effects are
         heterogeneous.

{p 8 11 2}
      h. {cmd:estat gatetest} tests whether the estimated GATEs or GATESs
         are equal across the groups.

{p 8 11 2}
      i. {cmd:estat classification} compares the means of a variable in the
         group with the largest treatment effect and the group with the
         smallest treatment effect.

{p 8 11 2}
      j. {cmd:estat projection} provides a linear approximation of the IATE
         function by fitting a linear regression of the estimated IATE on a
         set of variables.

{p 8 11 2}
      k. {cmd:estat series} provides a nonparametric approximation of the
         IATE function by fitting a series regression of the estimated IATE on
         a set of variables using B-spline, piecewise polynomial spline, or
         polynomial basis.

{p 5 8 2}
    2. Existing estimation command {helpb teffects aipw} has the following 
       improvements:

{p 8 11 2}
     a. Option {cmd:atet} can now be specified to estimate average
        treatment effects on the treated.

{p 8 11 2}
     b. {cmd:pweight}s can now be specified to adjust results for
        sampling weights.

{p 5 8 2}
    3. Existing estimation commands {helpb didregress} and 
       {helpb xtdidregress} have an improved algorithm to compute confidence 
       intervals with option {bf:wildbootstrap()}.  The estimators now use 
       option {bf:cistop(largest)} and the initial value logic from 
       command {helpb wildbootstrap}.  Previous results are preserved under
       version control.


{marker NewXT}{...}
{title:6 What's new in statistics (panel data)}

{p 5 8 2}
    1. {help whatsnew18to19##hdfe:Highlight of the release: High-dimensional fixed effects (HDFE)}

{p 8 8 2}
       Existing command {helpb xtreg:xtreg, fe} now allows option
       {opt absorb()} for absorbing categorical variables.  Results are
       adjusted to control for variables specified in 
       {cmd:absorb(}{it:varlist}{cmd:)}, but coefficients are not estimated, 
       which substantially reduces computation time.

{p 5 8 2}
    2. {help whatsnew18to19##cre:Highlight of the release: Correlated random-effects (CRE) model}

{p 8 8 2}
       Existing command {helpb xtreg} has new option {opt cre} to fit
       a CRE model, which deals with the endogeneity bias that may 
       because of the correlation between individual heterogeneity and 
       regressors and can estimate coefficients for time-invariant 
       regressors.

{p 5 8 2}
    3. {help whatsnew18to19##xtvar:Highlight of the release: Panel-data vector autoregressive (VAR) model}

{p 8 8 2}
       New estimation command {helpb xtvar} fits VAR models to panel data.  
       After {cmd:xtvar}, you can compute impulse-response functions, 
       perform Granger causality tests, evaluate the appropriate number of 
       lags and instruments to include in the model, and use other 
       diagnostics to which you are accustomed when fitting VAR models to 
       time-series data.

{p 5 8 2}
    4. {help whatsnew18to19##mundlak:Highlight of the release: Mundlak specification test}

{p 8 8 2}
       New postestimation command 
       {helpb xtreg_postestimation##syntax_estat:estat mundlak} is now
       available after {helpb xtreg} to perform a fully robust Mundlak 
       specification test to compare random-effects estimation  
       with fixed-effects estimation (or, equivalently, 
       correlated random-effects estimation).

{p 5 8 2}
    5. Existing command {helpb xtreg:xtreg, fe} has new option 
       {opt dfabsorb}.  This option adjusts degrees of freedom for 
       pairwise collinearity between variables specified in option 
       {opt absorb()}.
 

{marker NewST}{...}
{title:7 What's new in statistics (survival analysis)}

{p 5 8 2}
    1. {help whatsnew18to19##stmgint:Highlight of the release: Interval-censored multiple-event Cox model}

{p 8 8 2}
       New estimation command {helpb stmgintcox} fits a marginal Cox
       proportional hazards model to interval-censored multiple-event data 
       to account for possible dependence between event times for multiple 
       events.  After {cmd:stmgintcox}, you can create plots of
       covariate-adjusted survivor and other functions with {helpb stcurve}
       and produce goodness-of-fit plots with {helpb estat gofplot}.  You can
       also generate event-specific predictions; with
       {helpb stmgintcox_postestimation##predict:predict}'s new option
       {cmd:event()}, you can select the event for which you want predictions.
       You can use new postestimation command {helpb estat common} to
       estimate and test average effects of covariates across all events.

{p 5 8 2}
    2. Existing command {helpb sts graph} has new options {opt altrisktable}
       and {opt altrisktable()}, which provide an alternative at-risk table
       beneath the plot.  This table reports the number at risk, the 
       cumulative number lost, and the cumulative number of failures for each 
       time point on the {it:x} axis or at user-specified time points.
       The new table also allows customization via suboptions.
       Several new suboptions, including {opt show()}, {opt row()},
       and {opt grouptitle()}, are available for further customization.

{p 5 8 2}
    3. Existing command {helpb stcurve} has new options for customizing graphs 
       of survivor and related functions.  New graph options 
       {cmd:plot}{it:#}{cmd:opts()} and {cmd:atplot}{it:#}{cmd:opts()} control 
       the rendition of plots.  After {cmd:stmgitncox}, new options 
       {opt events()} and {cmd:sepevents} produce event-specific functions; 
       new option {cmd:event}{it:#}{cmd:opts()} controls the rendition of 
       event-specific plots; new option {cmd:graph}{it:#}{cmd:opts()} controls
       the look of the {it:#}th graph; and new option {opt byopts()} controls
       how subgraphs are combined and labeled.

{p 5 8 2}
    4. Existing command {helpb estat gofplot} has new options for customizing 
       goodness-of-fit plots.  New graph options {cmd:plot}{it:#}{cmd:opts()} 
       and {cmd:byplot}{it:#}{cmd:opts()} control the rendition of plots.
       After {cmd:stmgintcox}, new options {opt events()} and {cmd:sepevents}
       produce event-specific cumulative hazard functions; new option
       {cmd:event}{it:#}{cmd:opts()} controls the rendition of event-specific
       plots; and new options {cmd:graph}{it:#}{cmd:opts()} and
       {cmd:by}{it:#}{cmd:opts()} control the look of the {it:#}th graph.


{marker NewTS}{...}
{title:8 What's new in statistics (time series)}

{p 5 8 2}
    1. {help whatsnew18to19##ivsvar:Highlight of the release: SVAR via instrumental variables}

{p 8 8 2}
       New estimation command {helpb ivsvar} fits SVAR models via instrumental
       variables.  Instrumental-variables SVAR models, also called proxy 
       SVAR models, require fewer constraints to identify the structural
       impulse-response functions (IRFs) than are required by the traditional
       SVAR models fit by {cmd:svar}.  {cmd:ivsvar gmm} provides a generalized 
       method of moments (GMM) estimator, and {cmd:ivsvar mdist} provides 
       a minimum distance estimator.  After {cmd:ivsvar}, the {helpb irf} 
       suite can be used to graph structural IRFs.

{p 5 8 2}
    2. {help whatsnew18to19##ivlpirf:Highlight of the release: Instrumental-variables local projections for IRFs}

{p 8 8 2}
       New estimation command {helpb ivlpirf} fits local-projection models
       to estimate IRFs and uses instrumental variables to account for
       endogeneity in an impulse variable of interest.  After {cmd:ivlpirf}, 
       you can perform tests of hypotheses involving single or joint impulse 
       responses.  You can also use the {helpb irf} suite of commands to 
       produce tables and graphs of the estimated IRFs.

{p 5 8 2}
    3. Existing postestimation command {helpb irf create}, when used after
       {helpb ivsvar} or {helpb ivlpirf}, now computes statistic {cmd:csirf} 
       for cumulative structural IRFs.  Cumulative structural IRFs sum 
       individual IRFs and are useful for evaluating the total effect of a 
       shock over time.  You can graph these statistics with 
       {helpb irf graph}, {helpb irf cgraph}, and {helpb irf ograph}, and you can 
       tabulate them with {helpb irf table} and {helpb irf ctable}.

{p 5 8 2}
    4. Existing estimation command {helpb var} for fitting vector 
       autoregressive (VAR) models now supports option {cmd:vce(robust)} 
       to estimate robust standard errors.


{marker NewMeta}{...}
{title:9 What's new in statistics (meta-analysis)}

{p 5 8 2}
    1. {help whatsnew18to19##metacorr:Highlight of the release: Meta-analysis for correlations}

{p 8 8 2}
       The existing {helpb meta} suite is extended to perform meta-analysis of
       correlations.  {cmd: estat esize} supports option {opt fisherz}
       for meta-analysis using Fisher's {it:z}-transformed correlations 
       and option {opt correlation} for meta-analysis using raw 
       (untransformed) correlations.  All the commands in the {cmd:meta} 
       suite, such as {cmd:meta forestplot} and {cmd:meta funnelplot}, that 
       are available for two-sample binary or continuous data are also 
       available for correlation data.


{marker NewSEM}{...}
{title:10 What's new in statistics (structural equation models)}

{p 5 8 2}
    1. {help whatsnew18to19##lcstats:Highlight of the release: Latent class model-comparison statistics}

{p 8 8 2}
       New postestimation command {helpb lcstats} reports latent class 
       model-comparison statistics after fitting latent class models with 
       {helpb gsem}.  {cmd:lcstats} model-comparison statistics include 
       fitted log likelihood, sample size, rank, information criteria (AIC,
       BIC, AICC, CAIC), entropy, the Vuong-Lo-Mendell-Rubin likelihood-ratio 
       test, and the Lo-Mendell-Rubin-adjusted likelihood-ratio test.


{marker NewFMM}{...}
{title:11 What's new in statistics (finite mixture models)}

{p 5 8 2}
    1. {help whatsnew18to19##lcstats:Highlight of the release: Latent class model-comparison statistics}

{p 8 8 2}
       New postestimation command {helpb lcstats} reports latent class
       model-comparison statistics after fitting finite mixture models with
       {helpb fmm}.  {cmd:lcstats} model-comparison statistics include
       fitted log likelihood, sample size, rank, information criteria (AIC,
       BIC, AICC, CAIC), entropy, the Vuong-Lo-Mendell-Rubin likelihood-ratio
       test, and the Lo-Mendell-Rubin-adjusted likelihood-ratio test.


{marker NewSVY}{...}
{title:12 What's new in statistics (survey data)}

{p 5 8 2}
    1. {help whatsnew18to19##tables:Highlight of the release: More powerful tables}

{p 8 8 2}
       Existing command {helpb svy_tabulate:svy: tabulate} has new option 
       {cmd:collect()}.  This specifies that the tabulated statistics be 
       stored in a named collection with its own layout and styles, which 
       can be further customized and exported to a variety of file types.


{marker NewPSS}{...}
{title:13 What's new in statistics (power and sample size)}

{p 5 8 2}
    1. Existing commands {helpb power} and {helpb ciwidth} have new labels for 
       table columns that are ratios of two other columns.  The following
       commands are affected:

{p 8 11 2}
       a. {cmd:ciwidth twomeans} now labels column "nratio" as "N2/N1".

{p 8 11 2}
       b. {cmd:power cmh} now labels columns "grratio{it:#}" as
          "G2_{it:#}/N{it:#}".

{p 8 11 2}
       c. {cmd:power exponential} now labels column "nratio" as "N2/N1" 
          and labels column "hratio" as "h2/h1".

{p 8 11 2}
       d. {cmd:power logrank} now labels column "nratio" as "N2/N1".

{p 8 11 2}
       e. {cmd:power logrank, cluster} now labels column "nratio" as
          "N2/N1", column "kratio" as "K2/K1", and column "mratio"
          as "M2/M1".

{p 8 11 2}
       f. {cmd:power onevariance} now labels column "ratio" as "va/v0"
          when variances are specified and "sa/s0" when standard
          deviations are specified.

{p 8 11 2}
       g. {cmd:power pairedproportions} now labels column "ratio" as
          "p21/p12" when discordant proportions are specified and
          "pmarg2/pmarg1" when marginal proportions are specified.

{p 8 11 2}
       h. {cmd:power twocorrelations} now labels column "nratio" as
          "N2/N1".

{p 8 11 2}
       i. {cmd:power twomeans} now labels column "nratio" as "N2/N1".

{p 8 11 2}
       j. {cmd:power twomeans, cluster} now labels column "nratio" as
          "N2/N1", column "kratio" as "K2/K1", and column "mratio"
          as "M2/M1".

{p 8 11 2}
       k. {cmd:power twoproportions} now labels column "nratio" as
          "N2/N1" and labels column "ratio" as "p2/p1".

{p 8 11 2}
       l. {cmd:power twoproportions, cluster} now labels column "nratio"
          as "N2/N1", column "ratio" as "p2/p1", column "kratio"
          as "K2/K1", and column "mratio" as "M2/M1".

{p 8 11 2}
       m. {cmd:power twovariances} now labels column "nratio" as
          "N2/N1", and labels column "ratio" as "v2/v1" when variances are
          specified and "s2/s1" when standard deviations are specified.


{marker NewSP}{...}
{title:14 What's new in statistics (spatial data)}

{p 5 8 2}
    1. Existing command {helpb spmatrix create} is now substantially faster.


{marker NewDM}{...}
{title:15 What's new in data management}

{p 5 8 2}
    1. Existing command {helpb frames} has new subcommand
       {helpb frames modify}, enabling frames to be added, dropped,
       or replaced in the frameset on disk. {cmd: frames modify}
       works without loading the existing frameset into memory, which
       can be beneficial if the existing frameset is large or contains
       large frames.

{p 8 8 2}
       Learn more at
       {browse "https://www.stata.com/stata19/frames-modify/":stata.com/stata19/frames-modify}.

{p 5 8 2}
    2. Existing command {helpb reshape} now defaults to favoring {cmd:speed} 
       when {helpb set reshape_favor} {cmd:default} is in effect.  If user 
       version is less than 19, then {cmd:reshape} defaults to favoring 
       {cmd:memory} when {cmd:set reshape_favor default} is in effect.

{p 5 8 2}
    3. Existing command {helpb list} has three new options:

{p 8 11 2}
    a. Option {cmd:sepbyexp(}{it:{help exp}}{cmd:)} draws a separator line
       whenever the value of expression {it:exp} changes.  {it:exp} does not
       necessarily have to refer to variables in the dataset.

{p 8 11 2}
    b. Option {cmd:footer} displays variable names as a footer.

{p 8 11 2}
    c. Option {cmd:relative} specifies that relative observation numbers be 
       displayed.  By default, {cmd:list} with qualifiers {cmd:if} and 
       {cmd:in} displays the absolute observation numbers for the subset of 
       observations.  By adding new option {cmd:relative}, the relative 
       observation numbers will be displayed instead.  That is, observations 
       will be numbered 1, 2, 3, etc.


{marker NewG}{...}
{title:16 What's new in graphics}

{p 5 8 2}
    1. {help whatsnew18to19##graphics:Highlight of the release: New features in graphics}

{p 8 8 2}
       The following new graphics features are now available:

{p 8 11 2}
        a. New command {helpb twoway_heatmap:twoway heatmap} creates a
           heatmap, which displays values of a numeric variable, {it:z}, across
           values of {it:y} and {it:x} as a grid of colored rectangles.

{p 8 11 2}
        b. New command {helpb twoway_rpcap:twoway rpcap} creates a range and
           point plot with capped spikes.  These plots are useful for
           displaying a value of interest, such as a mean, and the
           corresponding confidence interval.  Markers are used to indicate
           the value of interest and capped spikes are used to indicate the
           range.

{p 8 11 2}
        c. New command {helpb twoway_rpspike:twoway rpspike} creates a range
           and point plot with spikes.  These plots are useful for displaying
           a value of interest, such as a mean, and the corresponding
           confidence interval.  Markers are used to indicate the value of
           interest and spikes are used to indicate the range.

{p 8 11 2}
        d. Existing command {helpb graph bar} has new features to 
           customize your bar graphs.

{p 11 14 2}
           1. {cmd:graph bar} supports new statistic {opt meanci}, which
              allows you to graph the mean and corresponding confidence
              interval.

{p 11 14 2}
           2. New options {opt cilevel()} and {opt ciline()} allow you
              to customize the confidence level and the look of the spike and 
              cap lines used to represent the confidence interval.

{p 11 14 2}
           3. New options {opt catlabellist()}, {opt catlabeladdmax}, and
              {opt catlabelformat()} allow you to control the ticks and 
              labels on the categorical axis.

{p 11 14 2}
           4. New option {opt groupyvars} allows you to group bars for the 
              same {it:y} variable together; this is useful when multiple 
              {it:y} variables are specified.

{p 11 14 2}
           5. New suboptions {opt prefix()} and {opt suffix()} in option
              {opt blabel()} allow you to add a prefix or suffix to the bar
              labels.

{p 8 11 2}
        e. Existing command {helpb graph dot} has new features to customize 
           your dot charts.

{p 11 14 2}
           1. {cmd:graph dot} supports new statistic {opt meanci}, which
              allows you to graph the mean and corresponding confidence
              interval.

{p 11 14 2}
           2. New options {opt cilevel()} and {opt ciline()} allow you
              to customize the confidence level and the look of the spike and 
              cap lines used to represent the confidence interval.

{p 11 14 2}
           3. New options {opt catlabellist()}, {opt catlabeladdmax}, and
              {opt catlabelformat()} allow you to control the ticks and 
              labels on the categorical axis.

{p 11 14 2}
           4. New option {opt groupyvars} allows you to group dots for the 
              same {it:y} variable together; this is useful when multiple 
              {it:y} variables are specified.

{p 8 11 2}
        f. Existing command {helpb graph box} has new features
           to customize your box plots.

{p 11 14 2}
           1. New options {opt catlabellist()}, {opt catlabeladdmax}, 
              and {opt catlabelformat()} allow you to control the ticks and 
              labels on the categorical axis.

{p 11 14 2}
           2. New option {opt groupyvars} allows you to group boxes for
              the same {it:y} variable together; this is useful when multiple
              {it:y} variables are specified.

{p 8 11 2}
        g. Existing option {helpb colorvar_options:colorvar()}
           is now available with more twoway plots: {helpb twoway line:line},
           {helpb twoway connected:connected}, {helpb twoway tsline:tsline},
           {helpb twoway rline:rline}, {helpb twoway rconnected:rconnected},
           and {helpb twoway tsrline:tsrline}.  This option allows plots to
           vary color of lines, markers, and more based on the values of a
           specified variable.

{p 8 11 2}
        h. {it:{help colorstyle}} now supports hexadecimal values, such as
           {cmd:"#ff0000"} for red and {cmd:"#00ff00"} for green.

{p 8 11 2}
        i. New suboption {opt lastlabel()} of option
           {helpb legend_options:legend()} allows you to override text for the
           final keys in the legend.  This suboption is especially useful with
           {helpb marginsplot}, which uses suboption {opt order()} to
           create the legend.

{p 8 11 2}
        k. New options {helpb marker_label_options:mlabprefix()} and
           {helpb marker_label_options:mlabsuffix()} allow you to add a prefix
           and suffix to the marker labels.  This is useful when you want to
           add a symbol, such as a dollar or percent sign, to your marker
           labels.


{marker NewRPT}{...}
{title:17 What's new in reporting}

{p 5 8 2}
    1. {help whatsnew18to19##tables:Highlight of the release: More powerful tables}

{p 8 8 2}
    The following new features for customizable tables are now available:

{p 8 11 2}
        a. Existing command {helpb table} has new options
           {cmd:title()}, {cmd:titlestyles()},
           {cmd:note()}, {cmd:notestyles()}, and
           {cmd:export()}.

{p 11 14 2}
           1. Option {cmd:title()} allows you to add a table title.

{p 11 14 2}
           2. Option {cmd:titlestyles()} allows you to control the
              appearance of the table title.

{p 11 14 2}
           3. Option {cmd:note()} allows you to add table notes.

{p 11 14 2}
           4. Option {cmd:notestyles()} allows you to control the appearance
              of the table notes.

{p 11 14 2}
           5. Option {cmd:export()} allows you to publish your table to a
              specified document type.

{p 8 11 2}
        b. Existing commands {helpb anova} and {helpb oneway} now store 
           their ANOVA table values in matrix {bf:r(ANOVA)}, making it easier
           to collect results and create customized ANOVA tables.

{p 8 11 2}
        c. Existing command {helpb collect get} has new option 
           {opt commands()} that lets you specify the command names that 
           posted the results being consumed.  This allows {cmd:collect get} 
           to search for command-specific result labels.

{p 8 11 2}
        d. New command {helpb collect query layout} allows you to query a
           collection's layout specification.

{p 8 11 2}
        e. Existing command {helpb collect style header} has new option 
           {opt fvlevels()} that specifies whether to hide or show 
           factor-variable levels when constructing row and column headers for a 
           given dimension.

{p 8 11 2}
        f. New command {helpb collect unget} allows you to
           remove specified results from a given collection.

{p 8 11 2}
        g. Existing command {helpb collect notes} has new option 
           {opt fortags()} that allows you to control which table to show 
           the specified note.

{p 8 11 2}
        h. Existing commands {helpb tabulate} and 
           {helpb svy_tabulate:svy: tabulate} have new option 
           {cmd:collect()}.  This option specifies that the
           tabulated statistics be stored in a named collection with
           its own layout and styles, which can be further customized
           and exported to a variety of file types.


{marker NewP}{...}
{title:18 What's new in programming}

{p 5 8 2}
    1. {helpb pystata:PyStata} features for integrating Python into Stata 
       and integrating Stata into Python have the following improvements:

{p 8 11 2}
       a. {cmd:Auto-completion}.  When running Stata code within an IPython 
          kernel-based environment, such as Jupyter Notebook and console as 
          well as Jupyter Lab and console, and within other environments 
          that support the IPython kernel, such as Spyder IDE and PyCharm IDE, 
          Stata’s variable names in the current working dataset, macro names, 
          and results {cmd:r()}, {cmd:e()}, and {cmd:s()} can now be 
          autocompleted as you type by pressing the {it:Tab} key.

{p 11 11 2}
         You can enable or disable autocompletion by using new function
         {browse "https://www.stata.com/python/pystata19/config.html#pystata.config.set_autocompletion":{bf:set_autocompletion()}}
         in the
         {browse "https://www.stata.com/python/pystata19/config.html":config}
         module or by using new setting
         {browse "https://www.stata.com/python/pystata19/notebook/Magic%20Commands3.html":{bf:%pystata set autocompletion}}.

{p 8 11 2}
       b. {browse "https://www.stata.com/python/pystata19/notebook/Magic%20Commands4.html":{bf:%help magic}}.
	  A new line magic {cmd:%help} [{it:command_or_topic_name}] is now
	  available; it allows you to view the help information of the
	  specified Stata command or topic in the web browser.

{p 8 11 2}
       c. {bf:Control output}.  You can now control whether to echo the Stata 
          commands along with their output when executing them in the Python 
          environment; and you can control whether to display Stata’s output 
          simultaneously when the execution begins or to display the output 
          after Stata finishes execution.

{p 11 11 2}
          You can suppress Stata commands by using new argument
          {browse "https://www.stata.com/python/pystata19/notebook/Magic%20Commands1.html#-nocmd":{bf:-nocmd}}
          in the
          {browse "https://www.stata.com/python/pystata19/notebook/Magic%20Commands1.html#%stata-cell-magic":%%stata}
          magic.  You can also set whether to echo commands by using new function
          {browse "https://www.stata.com/python/pystata19/config.html#pystata.config.set_command_show":{bf:set_command_show()}}
          in the
          {browse "https://www.stata.com/python/pystata19/config.html":config}
          module or by using new setting
          {browse "https://www.stata.com/python/pystata19/notebook/Magic%20Commands3.html":{bf:%pystata set command_show}}.

{p 11 11 2}
	  You can control whether to display Stata's output while Stata 
          is executing by using new function
          {browse "https://www.stata.com/python/pystata19/config.html#pystata.config.set_streaming_output":{bf:set_streaming_output()}}
          in the
          {browse "https://www.stata.com/python/pystata19/config.html":config}
          module or by using new setting
          {browse "https://www.stata.com/python/pystata19/notebook/Magic%20Commands3.html":{bf:%pystata set streaming_output}}.

{p 8 11 2}
       d. {bf:New BreakError class}.  In the {cmd:sfi module}, new class 
          {browse "https://www.stata.com/python/api19/BreakError.html":BreakError}
	  is available; it allows for interrupting Python execution by using
	  the {it:Break} key in Stata.  When executing a time-consuming Python
	  task within Stata, it may be necessary to interrupt the task and
	  return control to Stata.  When {it:Break} is pressed, the Python
	  task can now recognize this event, and a {cmd:BreakError} exception
	  will be triggered from the Python environment in Stata.  This
	  exception can be further caught within a {cmd:try/except} Python
	  block.  It gives users the flexibility to terminate a time-consuming
	  Python task and handle a clean-up task before returning control to
	  Stata.

{p 5 8 2}
    2. The {browse "https://www.stata.com/python/api19":Stata-Python API Specification}
       has the following new features:

{p 8 11 2}
       a. Class {browse "https://www.stata.com/python/api19/Frame.html":Frame}
          has new function
          {browse "https://www.stata.com/python/api19/Frame.html#sfi.Frame.getCWF":{bf:getCWF(}{bf:)}}
          that returns the name of the current working frame in Stata.

{p 8 11 2}
       b. Class {browse "https://www.stata.com/python/api19/Frame.html":Frame}
          has new function
          {browse "https://www.stata.com/python/api19/Frame.html#sfi.Frame.getName":{bf:getName(}{bf:)}}
          that returns the name of the frame.

{p 8 11 2}
       c. Class {browse "https://www.stata.com/python/api19/Frame.html":Frame}
          has new function
          {browse "https://www.stata.com/python/api19/Frame.html#sfi.Frame.getFrames":{bf:getFrames(}{bf:)}}
          that returns the names of all frames in Stata.

{p 5 8 2}
    3. The {browse "https://www.stata.com/java/api19":Stata-Java API Specification}
       has the following new features:

{p 8 11 2}
       a. Class {browse "https://www.stata.com/java/api19/com/stata/sfi/Frame.html":Frame}
          has new function
          {browse "https://www.stata.com/java/api19/com/stata/sfi/Frame.html#sfi.Frame.getCWF":{bf:getCWF(}{bf:)}}
          that returns the name of the current working frame in Stata.

{p 8 11 2}
       b. Class {browse "https://www.stata.com/java/api19/com/stata/sfi/Frame.html":Frame}
          has new function
          {browse "https://www.stata.com/java/api19/com/stata/sfi/Frame.html#sfi.Frame.getName":{bf:getName(}{bf:)}}
          that returns the name of the frame.

{p 8 11 2}
       c. Class {browse "https://www.stata.com/java/api19/com/stata/sfi/Frame.html":Frame}
          has new function
          {browse "https://www.stata.com/java/api19/com/stata/sfi/Frame.html#sfi.Frame.getFrames":{bf:getFrames(}{bf:)}}
          that returns the names of all frames in Stata.

{p 5 8 2}
    4. Commands {helpb matrix accum} and {helpb matrix vecaccum} now support
       samples with one observation.  Before this change, these
       commands would exit with error
       "{error:insufficient observations}" when presented with a
       single observation sample.  The old behavior is preserved
       under version control.


{marker NewMata}{...}
{title:19 What's new in Mata}

{p 5 8 2}
    1. Stata, when run on computers with Intel and AMD processors, uses the
       Intel Math Kernel Library (MKL), a highly optimized library of 
       mathematical functions developed by Intel.  MKL includes support for 
       the Basic Linear Algebra Subprograms (BLAS), a library of routines for 
       performing linear algebra operations such as vector and matrix 
       multiplication, and more.  In fact, MKL provides a highly optimized 
       implementation of BLAS that provides substantive performance 
       improvements.  However, MKL is not available for Macs with Apple 
       silicon.  Stata for Mac on Apple silicon used an older implementation 
       of BLAS, which was not written to take full advantage of modern
       processor capabilities.

{p 8 8 2}
       Stata for Mac on Apple silicon now uses LAPACK/OpenBLAS for numerical
       computations.  OpenBLAS is an open-source implementation of the BLAS 
       and is optimized for modern hardware platforms, making it more up to 
       date and faster than the previous LAPACK/BLAS implementation that 
       older versions of Stata used.  OpenBLAS support is currently limited
       to Apple silicon, and the previous LAPACK/BLAS implementation is still 
       available via a setting.
 
{p 5 8 2}
    2. New Mata function {helpb mf__invmat:_invmat()} finds the inverse of a 
       square matrix (or the pseudoinverse if the matrix is not invertible).

{p 5 8 2}
    3. New Mata function {helpb mf__solvemat:_solvemat()} solves AX=B, and it 
       allows you to specify the type of the matrix, such as lower triangular
       or symmetric and positive definite, and chooses the suitable solver 
       correspondingly.

{p 5 8 2}
    4. Existing Mata function {helpb mf_deriv:deriv()} has the following 
       improvements:

{p 8 11 2}
       a. You can now use the Richardson extrapolation method to compute the 
          numerical derivatives by specifying {cmd:"richardson"} in 
          function {cmd:deriv_init_technique()}.

{p 8 11 2}
       b. You can now use {cmd:deriv_init_tablesize()} to specify the 
          table size for computing numerical derivatives using the 
          Richardson extrapolation method.

{p 5 8 2}
    5. New Mata function {helpb mf_lssolve:lssolve()} solves AX=B for the 
       minimum-norm solution X by using the least-squares method.

{p 5 8 2}
    6. New Mata function {helpb mf_lsesolve:lsesolve()} solves AX=c with 
       equality constraints for the minimum-norm solution X using 
       the least-squares method.

{p 5 8 2}
    7. New Mata function {helpb mf_lsglmsolve:lsglmsolve()} finds the 
       solution of a general Gauss-Markov linear model with equality 
       constraints.

{p 5 8 2}
    8. New Mata function {helpb mf_st_nvar:st_datalabel()} returns the 
       label of the dataset currently loaded in Stata.

{p 5 8 2}
    9. New Mata function 
       {helpb mf_st_nvar:st_datalabel({it:string scalar name})} sets or resets
       the label of the dataset currently loaded in Stata.

{p 4 8 2}
   10. New Mata function {helpb mf_st_vlexists:st_vldir()} returns a string 
       vector of names of all value labels.


{marker NewGUI}{...}
{title:20 What's new in the interface}

{p 5 8 2}
    1. {help whatsnew18to19##doedit:Highlight of the release: Do-file Editor enhancements}


{p 8 11 2}
     a. {bf:Autocompletion of variable names, macros, and stored results}.  The
        Do-file Editor now includes the ability to autocomplete variable
        names from data in memory, macros, and stored results.  If you pause
        briefly as you type, suggestions will appear.  More typing will
        narrow down the possibilities.  You can navigate the
        suggestions by using the up- and down-arrow keys or keep typing to
        narrow them to a single word.  Once you have the word you like,
        you can press {bf:Return} to place the word in your do-file.

{p 11 11 2}
        Autocompletion preferences can be set by using the following new
        check boxes:

{p 11 14 2}
         1. {bf:Autocompletion > Autocomplete using macro names}.  When this
            is checked, local macro names and global macro names in memory
            can be autocompleted.

{p 11 14 2}
          2. {bf:Autocompletion > Autocomplete using r(), e(), and s() results}.
             When this is checked, stored result names in memory can be
             autocompleted.

{p 11 14 2}
          3. {bf:Autocompletion > Autocomplete while typing strings}.  Only
             when this is checked will text within quotes be autocompleted.

{p 11 14 2}
          4. {bf:Autocompletion > Autocomplete while typing comments}.  Only
             when this is checked will the text of a comment be autocompleted.

{p 8 11 2}
     b. {bf:Do-file Editor templates}.  By popular request, you can now save
        time and ensure consistency when you create new documents in the
        Do-file Editor by using Stata templates and user-defined
        templates.  You can access templates by using the menu
        {bf:New > Document from template}.  Selecting an item from the
        templates menu will open an editor and set the contents of the editor
        to the contents of the template.  You can define your own templates by
        creating the {cmd:document_templates} directory in your {cmd:PERSONAL}
        directory and then saving template files into that directory.  See
        {findalias gswdoedit} (or {findalias gsmdoedit} or
        {findalias gsudoedit}) to learn more.

{p 8 11 2}
     c. {bf:Do-file Editor current word and selection highlighting}.
        The Do-file Editor will now highlight all case-insensitive
        occurrences of the current word under the cursor.  It will also
        separately highlight all case-sensitive occurrences of the current
        selection.  You can limit highlighting of the current word to
        comments, functions, keywords, macros, and strings.  These features
        can be disabled in the Do-file Editor preferences dialog.

{p 8 11 2}
     d. {bf:Bracket highlighting}.  There are existing tools for matching
        brackets as well as selecting text within brackets.  The Do-file Editor
        will now highlight the brackets enclosing the current cursor position
        as you move through the document.

{p 8 11 2}
     e. {bf:Code folding enhancements}.  Code folding allows you to
        selectively hide parts of a document so that you can focus
        on sections of interest.  Stata’s Do-file Editor allows you to
        selectively fold blocks of code in a do-file, such as programs,
        Mata code, Python code, functions, and {cmd:if} statements, by
        collapsing them to a single line.  You can now quickly fold all
        foldable blocks of code in your do-file by using the {bf:Fold all}
        menu item.  You can then selectively unfold your code one fold
        point at a time to show the more important parts of your do-file,
        or you can use the Do-file Editor’s {bf:Unfold all} menu item to
        unfold every fold point.  You can also select lines of code and
        transform them into a foldable block of code by using the
        {bf:Fold selection} menu item.  This can tidy up your code and
        increase the code’s readability.  There is a new
        setting for the Do-file Editor that will automatically fold every
        foldable block of code of a do-file when it is opened.
        Finally, the code folding feature is now less visually
        distracting.  The code folding ribbon now uses arrow markers to
        indicate whether a code fold is expanded or collapsed.  The expanded
        code fold marker is hidden until the user hovers their mouse over the
        code folding ribbon.  The collapsed code fold marker is always visible,
        and the first line of a collapsed code fold is highlighted.

{p 8 11 2}
     f. {bf:Do-file Editor temporary and permanent bookmarks}.
        By popular request, the Do-file Editor now supports temporary
        bookmarks in addition to permanent bookmarks.  Bookmarks allow you
        to easily navigate through your do-file.  The existing permanent
        bookmarks are saved as part of the do-file.  You can use the new
        temporary bookmarks to immediately navigate your do-file but without
        making any changes to its content.  Temporary bookmarks can be added
        to any line that does not already contain a permanent bookmark and
        are removed when your do-file is closed.  To add a temporary bookmark
        in the Do-file Editor of Stata for Windows and Stata for Unix, select
        menu item {bf:Edit > Toggle temporary bookmark} or press the {it:Alt}
        key and click on the bookmark margin of a line.  To add a temporary
        bookmark in the Do-file Editor of Stata for Mac, select menu item
        {bf:Edit > Find > Toggle temporary bookmark} or press the {it:Option}
        key and click on the bookmark margin of a line.  Read 
        {findalias gswdoedit}, {findalias gsmdoedit}, or {findalias gsudoedit} 
        to learn how to use temporary bookmarks in the Do-file Editor.

{p 8 11 2}
     g. {bf:Show whitespace and tabs}.  The Do-file Editor can show whitespace
        character spaces and tabs using the {bf:Show whitespace} menu item or
        toolbar button.  The Do-file Editor can now show whitespace characters
        only within a selection instead of always showing them or not
        showing them at all.

{p 8 11 2}
     h. {bf:Navigator panel}.  The Navigation control from previous releases
        of Stata has been replaced by the Navigator panel.  It displays a list
        of permanent bookmarks and programs that are in a do-file.  You can
        quickly jump to the position of a program or bookmark by
        double-clicking on the item in the Navigator panel.  You can also
        delete and indent bookmarks from the Navigator panel.  The Navigator
        panel is hidden by default, but you can make it visible by selecting
        {bf:View > Show Navigator}.

{p 5 8 2}
    2. {help whatsnew18to19##french:Highlight of the release: Stata in French}

{p 8 8 2}
      Stata's menus, dialogs, and the like can now be displayed in
      French.  If your computer language is set to French ({cmd:fr}), Stata
      will automatically use its French setting.  To change languages manually
      using Windows or Unix,
      select {bf:Edit > Preferences > User-interface language...}.  If you are
      using MacOS, select
      {bf:Stata 19 > Preferences > User-interface language...}.  You can also
      change the language from the command line; see
      {helpb set locale_ui:[P] set locale_ui}.

{p 5 8 2}
    3. Stata now shows the name of the {helpb cwf:current (working) frame}
       in the title bar when multiple {helpb frames} are present.  This
       allows you to easily identify the frame in which any commands issued
       without a {helpb frame_prefix:frame prefix} will be executed.  If only
       one frame exists (the default), then the name of the current frame
       will not be shown in the title bar.


{marker NewMore}{...}
{title:21  What's more}

{pstd}
We have not listed all the changes, but we have listed the important ones.

{pstd}
Stata is continually being updated.  Those between-release updates are
available for free over the Internet.

{pstd}
Type {bf:{stata update query:update query}} and follow the instructions.

{pstd}
We hope that you enjoy Stata 19.


{hline 8} {hi:previous updates} {hline}

{pstd}
See {help whatsnew18}.

{hline}
